//
//  Detecting_Swipe_GesturesViewController.m
//  Detecting Swipe Gestures
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Detecting_Swipe_GesturesViewController.h"

@implementation Detecting_Swipe_GesturesViewController

@synthesize swipeGestureRecognizer;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (void) handleSwipes:(UISwipeGestureRecognizer *)paramSender{
  
  if (paramSender.direction & UISwipeGestureRecognizerDirectionDown){
    NSLog(@"Machnięcie w dół.");
  }
  if (paramSender.direction & UISwipeGestureRecognizerDirectionLeft){
    NSLog(@"Machnięcie w lewo.");
  }
  if (paramSender.direction & UISwipeGestureRecognizerDirectionRight){
    NSLog(@"Machnięcie w prawo.");
  }
  if (paramSender.direction & UISwipeGestureRecognizerDirectionUp){
    NSLog(@"Machnięcie w górę.");
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  /* Utworzenie obiektu. */
  self.swipeGestureRecognizer = [[UISwipeGestureRecognizer alloc] 
                                 initWithTarget:self 
                                 action:@selector(handleSwipes:)];
  
  /* Wykryty będzie gest machnięcia wykonany od prawej do lewej strony. */
  self.swipeGestureRecognizer.direction = 
    UISwipeGestureRecognizerDirectionLeft;
  
  /* Do wykonania gestu wymagany jest tylko jeden palec. */
  self.swipeGestureRecognizer.numberOfTouchesRequired = 1;
  
  /* Dodanie obiektu do widoku. */
  [self.view addGestureRecognizer:self.swipeGestureRecognizer];
  
}

- (void) viewDidUnload{
  [super viewDidUnload]; 
  self.swipeGestureRecognizer = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
